// CÓDIGO MEGA SIMPLES - FUNCIONA NO ANDROID E iOS

// 1. Variável para instalação Android
let deferredPrompt;

// 2. Função para verificar se é iPhone/iPad
function isiPhone() {
    return /iPhone|iPad|iPod/.test(navigator.userAgent);
}

// 3. Função para verificar se já está instalado
function isInstalled() {
    return window.matchMedia('(display-mode: standalone)').matches || 
           window.navigator.standalone === true;
}

// 4. Função principal quando a página carrega
window.addEventListener('load', function() {
    console.log('Página carregada - inicializando PWA');
    
    // Esconder splash screen
    setTimeout(() => {
        const splashScreen = document.getElementById('splash-screen');
        if (splashScreen) {
            splashScreen.classList.add('hidden');
            setTimeout(() => {
                splashScreen.style.display = 'none';
            }, 500);
        }
    }, 1500);
    
    // Verificar se já está instalado
    if (isInstalled()) {
        console.log('App já está instalado');
        hideInstallButton();
    }
    
    // Configurar PWA para Android/Chrome
    setupAndroidPWA();
    
    // Configurar para iPhone/iPad
    if (isiPhone() && !isInstalled()) {
        setupiPhonePWA();
    }
});

// 5. Configurar PWA para Android/Chrome
function setupAndroidPWA() {
    window.addEventListener('beforeinstallprompt', function(e) {
        console.log('beforeinstallprompt disparado');
        e.preventDefault();
        deferredPrompt = e;
        
        // Mostrar botão de instalação
        showInstallButton();
    });
    
    // Quando o app for instalado
    window.addEventListener('appinstalled', function() {
        console.log('App instalado com sucesso!');
        hideInstallButton();
        deferredPrompt = null;
        
        // Mostrar mensagem de sucesso
        alert('🎉 App instalado com sucesso! Agora você pode acessá-lo diretamente da tela inicial.');
    });
}

// 6. Configurar para iPhone/iPad
function setupiPhonePWA() {
    console.log('Dispositivo iOS detectado');
    
    // Mostrar botão após 3 segundos
    setTimeout(function() {
        // Verificar se já tem botão
        if (document.getElementById('iphoneInstallBtn')) return;
        
        // Criar botão flutuante
        var iphoneBtn = document.createElement('button');
        iphoneBtn.id = 'iphoneInstallBtn';
        iphoneBtn.innerHTML = '📲 ADD à TELA INICIAL';
        iphoneBtn.style.cssText = `
            position: fixed;
            bottom: 100px;
            right: 15px;
            background: linear-gradient(135deg, #ff6b35 0%, #ff8b35 100%);
            color: white;
            border: none;
            padding: 12px 16px;
            border-radius: 25px;
            font-weight: bold;
            font-size: 14px;
            z-index: 9999;
            box-shadow: 0 4px 15px rgba(255, 107, 53, 0.4);
            cursor: pointer;
        `;
        
        // Quando clicar
        iphoneBtn.onclick = function() {
            alert('📱 NO IPHONE/IPAD:\n\n1. Toque no botão "COMPARTILHAR" (setinha pra cima)\n2. Role e toque em "ADICIONAR À TELA DE INÍCIO"\n3. Toque em "ADICIONAR"\n\nDepois disso, o app aparecerá na sua tela inicial!');
            this.remove();
        };
        
        // Adicionar botão
        document.body.appendChild(iphoneBtn);
        
        // Remover após 30 segundos
        setTimeout(function() {
            const btn = document.getElementById('iphoneInstallBtn');
            if (btn && btn.parentNode) {
                btn.remove();
            }
        }, 30000);
    }, 3000);
}

// 7. Função para mostrar botão de instalação
function showInstallButton() {
    const installBtn = document.getElementById('installBtn');
    if (installBtn) {
        installBtn.style.display = 'flex';
        console.log('Botão de instalação mostrado');
    }
}

// 8. Função para esconder botão de instalação
function hideInstallButton() {
    const installBtn = document.getElementById('installBtn');
    if (installBtn) {
        installBtn.style.display = 'none';
    }
}

// 9. Função principal chamada pelo botão "Instalar App"
function installApp() {
    console.log('Botão de instalação clicado');
    
    if (deferredPrompt) {
        // Android/Chrome
        console.log('Solicitando instalação Android...');
        deferredPrompt.prompt();
        
        deferredPrompt.userChoice.then(function(choice) {
            console.log('Usuário escolheu:', choice.outcome);
            
            if (choice.outcome === 'accepted') {
                console.log('Usuário aceitou instalar');
                hideInstallButton();
            } else {
                console.log('Usuário recusou instalar');
            }
            deferredPrompt = null;
        });
    } else if (isiPhone()) {
        // iPhone/iPad
        console.log('Mostrando instruções iOS...');
        alert('📱 NO IPHONE/IPAD:\n\n1. Toque no botão "COMPARTILHAR" (ícone de compartilhamento)\n2. Role para baixo e toque em "ADICIONAR À TELA DE INÍCIO"\n3. Toque em "ADICIONAR" no canto superior direito\n\nPronto! O app será adicionado à sua tela inicial.');
    } else {
        // Outros navegadores
        console.log('Navegador não suporta instalação direta');
        alert('ℹ️ Para instalar este app:\n\n1. No Chrome/Edge: Clique nos 3 pontos → "Instalar..."\n2. No Firefox: Clique no ícone de casa → "Instalar Site"\n3. No Safari: Compartilhar → "Adicionar à Tela Inicial"');
    }
}

// 10. Inicializar quando o DOM estiver pronto
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM carregado - app pronto');
    
    // Garantir que a splash screen desapareça
    setTimeout(() => {
        const splash = document.getElementById('splash-screen');
        if (splash && !splash.classList.contains('hidden')) {
            splash.classList.add('hidden');
            setTimeout(() => {
                splash.style.display = 'none';
            }, 500);
        }
    }, 2000);
});