// CÓDIGO MEGA SIMPLES - FUNCIONA NO ANDROID E iOS

// 1. Variável para instalação Android
let deferredPrompt;

// 2. Quando a página carregar
window.addEventListener('load', function() {
  
  // 3. Função para iPhone/iPad
  function isiPhone() {
    return /iPhone|iPad|iPod/.test(navigator.userAgent);
  }
  
  // 4. Função para verificar se já está instalado
  function isInstalled() {
    return window.matchMedia('(display-mode: standalone)').matches;
  }
  
  // 5. Se já está instalado, esconde botões
  if (isInstalled()) {
    document.getElementById('installBtnHero').classList.add('hidden');
  }
  
  // ============ PARA ANDROID/CHROME ============
  window.addEventListener('beforeinstallprompt', function(e) {
    e.preventDefault();
    deferredPrompt = e;
    
    // Mostra botões
    document.getElementById('installBtnHero').classList.remove('hidden');
  });
  
  // Quando o app for instalado (Android)
  window.addEventListener('appinstalled', function() {
    document.getElementById('installBtnHero').classList.add('hidden');
    deferredPrompt = null;
  });
  
  // ============ PARA IPHONE/IPAD ============
  if (isiPhone() && !isInstalled()) {
    // Mostra botão especial após 3 segundos
    setTimeout(function() {
      showiPhoneButton();
    }, 3000);
  }
});

// 6. Botão flutuante para iPhone/iPad
function showiPhoneButton() {
  // Cria botão
  var iphoneBtn = document.createElement('button');
  iphoneBtn.innerHTML = '📲 Instalar App';
  iphoneBtn.style.cssText = `
    position: fixed;
    bottom: 90px;
    right: 15px;
    background: #8b5cf6;
    color: white;
    border: none;
    padding: 12px 16px;
    border-radius: 25px;
    font-weight: bold;
    font-size: 14px;
    z-index: 9999;
    box-shadow: 0 4px 15px rgba(139, 92, 246, 0.4);
    cursor: pointer;
  `;
  
  // Quando clicar
  iphoneBtn.onclick = function() {
    alert('📱 NO IPHONE/IPAD:\n\n1. Toque no botão "COMPARTILHAR" (setinha pra cima)\n2. Role e toque em "ADICIONAR À TELA DE INÍCIO"\n3. Toque em "ADICIONAR"');
    iphoneBtn.remove();
  };
  
  // Adiciona botão
  document.body.appendChild(iphoneBtn);
  
  // Remove após 30 segundos
  setTimeout(function() {
    if (iphoneBtn.parentNode) {
      iphoneBtn.remove();
    }
  }, 30000);
}

// 7. Função chamada pelo botão "Instalar App"
function installApp() {
  if (deferredPrompt) {
    // Android
    deferredPrompt.prompt();
    deferredPrompt.userChoice.then(function(choice) {
      if (choice.outcome === 'accepted') {
        document.getElementById('installBtnHero').classList.add('hidden');
      }
      deferredPrompt = null;
    });
  } else if (/iPhone|iPad|iPod/.test(navigator.userAgent)) {
    // iPhone/iPad - mostra instruções
    alert('📱 NO IPHONE/IPAD:\n\n1. Toque no botão "COMPARTILHAR" (setinha pra cima)\n2. Role e toque em "ADICIONAR À TELA DE INÍCIO"\n3. Toque em "ADICIONAR"');
  }
}